import javax.imageio.ImageIO;
import javax.swing.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import java.util.*;

class CustomMenu extends JMenuBar{

	private static final long serialVersionUID = 449185584601867436L;
	
    public Map<String,JMenu> menuCollection;

    MainFrame owner;
    
    CustomMenu(MainFrame owner) {
        super();
        this.owner = owner;
        buildInstance();
    }

    private void buildInstance() {
        // Create the menu collection
        menuCollection = new HashMap<String,JMenu>();
        // Local auxiliary variables
        JMenu menu;
        JMenuItem menuItem;
        // The "File" Menu
        menuCollection.put("File", new JMenu("File"));
        menu = menuCollection.get("File");
        menuItem = menu.add(new JMenuItem("Exit"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, ActionEvent.ALT_MASK));
        menuItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                owner.exitGracefully();
            }
            
        });
        this.add(menu);
        // The "About" Menu
        menuCollection.put("Help", new JMenu("Help"));
        menu = menuCollection.get("Help");
        menuItem = menu.add(new JMenuItem("About"));
        menuItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(owner, owner.getAboutInformation());
            }

        });
        this.add(menu);
    }

}

class Animatie extends Thread {

	Image img;
	
	public Animatie(){
		img = new BufferedImage(600,400, BufferedImage.TYPE_INT_ARGB);
	}
	
	@Override
	public void run() {
		while (true){
			try {
				Thread.sleep(75);
				MainFrame.depiction.paint(img.getGraphics());
				MainFrame.otherCanvas.getGraphics().drawImage(img, 0, 0, null);
				MainFrame.stats.setText("Stats: STEP =" + MainFrame.lastSimulatedStep + "| ERRORS = " + MainFrame.myMap.totalFaults);
			} catch (Exception e) {
			}
		}
	}
	
}

class ButtonBar extends JPanel implements ActionListener, Runnable {
	
	public void run() {
		while(MainFrame.lastSimulatedStep < 100){
			try {
				Thread.sleep(100);
				takeAStep();
				if (MainFrame.myMap.hasHadErrors){
					break;
				}
			} catch (Exception exception) {
			    break;
			}
		}
	}
	
	private static final long serialVersionUID = 1L;
	
	JButton loadButton;
	JButton resetButton;
	JButton startButton;
	JButton saveButton;
	JButton nextStepButton;
	JButton runButton;
	JCheckBox compareCheckBox;
	JTextField comparePath;
	JTextField initialPath;
	JFileChooser fileChooser;
	
	MainFrame owner;
	
	public ButtonBar(MainFrame owner) {
		super();
		this.owner = owner;
		this.setLayout(new GridBagLayout());
		GridBagConstraints localConstraints;
		this.setBorder(new TitledBorder("Control panel:"));
		// Creating the paths
		loadButton = new JButton("Load initial map");
		loadButton.addActionListener(this);
		localConstraints = new GridBagConstraints(0,0,30,20,0,0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2,2,2,2),0,0);
		this.add(loadButton, localConstraints);
		initialPath = new JTextField();
		initialPath.setEditable(false);
		localConstraints = new GridBagConstraints(30,0,100,20,1,0,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(2,2,2,2),0,0);
		this.add(initialPath, localConstraints);
		compareCheckBox = new JCheckBox("Compare to my output",false);
		compareCheckBox.addActionListener(this);
		localConstraints = new GridBagConstraints(0,20,30,20,0,0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2,2,2,2),0,0);
		this.add(compareCheckBox, localConstraints);
		comparePath = new JTextField();
		comparePath.setEditable(false);
		localConstraints = new GridBagConstraints(30,20,100,20,1,0,GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(2,2,2,2),0,0);
		this.add(comparePath, localConstraints);
		// Creating the buttons on the lower row
		startButton = new JButton("Start");
		startButton.addActionListener(this);
		localConstraints = new GridBagConstraints(0,40,30,20,0,0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2,2,2,2),0,0);
		this.add(startButton, localConstraints);
		resetButton = new JButton("Reset");
		resetButton.addActionListener(this);
		localConstraints = new GridBagConstraints(30,40,30,20,0,0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2,2,2,2),0,0);
		this.add(resetButton, localConstraints);
		nextStepButton = new JButton("Next Step");
		nextStepButton.addActionListener(this);
		localConstraints = new GridBagConstraints(60,40,30,20,0,0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2,2,2,2),0,0);
		this.add(nextStepButton, localConstraints);
		runButton = new JButton("Run");
		runButton.addActionListener(this);
		localConstraints = new GridBagConstraints(90,40,30,20,0,0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2,2,2,2),0,0);
		this.add(runButton,localConstraints);
		saveButton = new JButton("Save");
		saveButton.addActionListener(this);
		localConstraints = new GridBagConstraints(120,40,30,20,0,0,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2,2,2,2),0,0);
		this.add(saveButton,localConstraints);
		
		// Make the file chooser
		fileChooser = new JFileChooser();
	}

	private void resetAll(String s) {
		if (s != ""){
			JOptionPane.showMessageDialog(null, s);
		}
		if (MainFrame.run != null){
			MainFrame.run.interrupt();
			MainFrame.run = null;
		}
		MainFrame.myMap = null;
		MainFrame.hisMap = null;
		MainFrame.lastSimulatedStep = -1;
		MainFrame.depiction.setGameMap(null);
	}
	
	private void takeAStep() {
		try {
			MainFrame.myMap.takeAction();
			if (MainFrame.hisMap != null){
				MainFrame.hisMap.takeAction();
				MainFrame.myMap.compare(MainFrame.hisMap);
			}
			MainFrame.lastSimulatedStep++;
		} catch (Exception exception) {
			resetAll("Your solution file has wrong format or ended unexpectedly:\n" + comparePath.getText());
		}
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == loadButton) {
			if (MainFrame.lastSimulatedStep != -1) {
				JOptionPane.showMessageDialog(owner, "Simulation already started!\n\nClick Reset");
			} else {
				int returnValue = fileChooser.showOpenDialog(null);
				if (returnValue == JFileChooser.APPROVE_OPTION) {
					File inputFile = fileChooser.getSelectedFile();
					initialPath.setText(inputFile.getPath());
				}
			}
		} else if (e.getSource() == nextStepButton) {
			takeAStep();
		} else if (e.getSource() == runButton) {
			if (MainFrame.run == null){
				MainFrame.run = new Thread(this);
				MainFrame.run.start();
			}
		} else if (e.getSource() == compareCheckBox) {
			if (MainFrame.lastSimulatedStep != -1) {
				JOptionPane.showMessageDialog(owner, "Simulation already started!\n\nClick Reset");
			} else if (compareCheckBox.isSelected()) {
				int returnValue = fileChooser.showOpenDialog(null);
				if (returnValue == JFileChooser.APPROVE_OPTION) {
					File inputFile = fileChooser.getSelectedFile();
					comparePath.setText(inputFile.getPath());
				} else {
					compareCheckBox.setSelected(false);
				} 
			} else {
				comparePath.setText("");
			}
		} else if (e.getSource() == resetButton) {
			resetAll("");
		} else if (e.getSource() == startButton) {
			try {
				MainFrame.myMap = new GameMap(initialPath.getText(), true);
				if (compareCheckBox.isSelected()){
					MainFrame.hisMap = new GameMap(comparePath.getText(), false);
					MainFrame.myMap.compare(MainFrame.hisMap);
				}
				MainFrame.depiction.setGameMap(MainFrame.myMap);
				MainFrame.lastSimulatedStep = 0;
			} catch (Exception exception){
				resetAll("Map file doesn't exist or has wrong format!\n" + exception.getMessage());
			}
		} else if (e.getSource() == saveButton) {
			if (MainFrame.lastSimulatedStep == -1) {
				JOptionPane.showMessageDialog(owner, "Simulate something first!");
			} else {
				int returnValue = fileChooser.showSaveDialog(null);
				if (returnValue == JFileChooser.APPROVE_OPTION) {
					try {
						File outputFile = fileChooser.getSelectedFile();
						PrintWriter out = new PrintWriter(new FileOutputStream(outputFile));
						MainFrame.myMap.save(out);
						out.close();
					} catch (IOException exception) {
						JOptionPane.showMessageDialog(null, "Could not save!");
					}
				} else {
					compareCheckBox.setSelected(false);
				} 
			} 
		}
	}
	
}

class RemoveWhiteFilter extends RGBImageFilter {

	int first = 0x00FFFFFF;
	
	@Override
	public int filterRGB(int x, int y, int rgb) {
		if (rgb == Color.white.getRGB()){
			return 0;
		}
		return rgb;		
	}
	
}

public class MainFrame extends JFrame {

	private static final long serialVersionUID = 1L;
	
	public static int lastSimulatedStep;
	static GameCanvas depiction;
	static Canvas otherCanvas;
	
	static GameMap myMap;
	static GameMap hisMap;
	
	static JLabel stats; 
	
	Thread animatie;
	static Thread run;
	
	static Map<String,Image> sprite;
	
	MainFrame() {
		super("Tema 2 - Simulator & Checker");
		// Set the window parameters
		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		// Set the menu bar
		this.setJMenuBar(new CustomMenu(this));
		// Create the layout
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(new ButtonBar(this),BorderLayout.NORTH);
		depiction = new GameCanvas(this);
		depiction.setSize(new Dimension(600,400));
		otherCanvas = new Canvas();
		otherCanvas.setSize(new Dimension(600,400));
		animatie = new Animatie();
		animatie.start();
		this.getContentPane().add(otherCanvas, BorderLayout.CENTER);
		// Consider last simulated step to be -1
		MainFrame.lastSimulatedStep = -1;
		pullSprites();
		// Make the status bar
		stats = new JLabel("Stats: ");
		this.getContentPane().add(stats, BorderLayout.SOUTH);
		// Make the window visible at the center of the screen
		this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((screenSize.width-this.getSize().width)/2,(screenSize.height-this.getSize().height)/2));
		this.setVisible(true);
		// Create the all states vector
	}
	
	public void pullSprites() {
		MainFrame.sprite = new TreeMap<String,Image>();
		try {
			String[] images = { "grass", "road", "tarmac", "carNorth", "carSouth", "carEast", "carWest", "coffee", "allowedNorth", "allowedEast", "allowedWest", "allowedSouth", "water", "crash" };
			ImageProducer producer;
			ImageFilter filter = new RemoveWhiteFilter();
			for (int i = 0; i < images.length; i++){
			    InputStream fileName = MainFrame.class.getClassLoader().getResourceAsStream("Img/" + images[i] + ".png");
				producer = new FilteredImageSource(ImageIO.read(fileName).getSource(), filter);
				sprite.put(images[i], createImage(producer));
			}
		} catch (Exception e){
			JOptionPane.showMessageDialog(null, "Error! Missing texture files!\n" + e.getMessage());
			System.exit(0);
		}
	}
	
	public void exitGracefully(){
		System.exit(0);
	}
	
	public String getAboutInformation() {
		return "Tema 2 - Simulator & Checker\nVersion: 1.1\n\nPlease send any bug reports to adrian.scoica@gmail.com\n\nPlease go to http://elf.cs.pub.ro/programare for any updates!";
	}
	
	public static void main (String[] args){
		new MainFrame();
	}
	
}
