import java.io.*;
import java.util.Vector;

public class GameMap {

	class Triplet {
		public int a,b,c;
		
		Triplet() {
			this(0,0,0);
		}
		
		Triplet (int a, int b, int c){
			this.a = a;
			this.b = b;
			this.c = c;
		}
	}
	
	int[][] gameMap;
	boolean[][] different;
	boolean isInitial;
	boolean hasHadErrors;
	StreamTokenizer strtok;
	Vector<int[][]> allStates;
	
	int totalFaults;
	
	private static final int[] vi = {0, -1, 0, 1,  0};
	private static final int[] vj = {0,  0, 1, 0, -1};
	
	public final static int TERRAIN = 0;
	public final static int ROADMAP = 1;
	public final static int CAR = 2;
	public final static int ACCIDENTS = 3;
	
	void save(PrintWriter f) throws IOException {
		for (int it = 0; it < allStates.size(); it++) {
			int[][] gameMap = allStates.elementAt(it);
			for (int i = 0; i < 20; i++){
				for (int j = 0; j < 30; j++){
					f.print(gameMap[i][j] % 10000);
					f.print(" ");
				}
				f.print("\n");
			}
			f.write("\n");
		}
	}
	
	static int getFigureGeneral(int source, int number){
		int returnValue = source;
		for (int k = 0; k < number; k++){
			returnValue /= 10;
		}
		return returnValue%10;
	}
	
	static int setFigureGeneral(int source, int number, int newValue){
		int oldValue = getFigureGeneral(source,number);
		for (int k = 0; k < number; k++){
			oldValue *= 10;
			newValue *= 10;
		}
		return source - oldValue + newValue;
	}
	
	public int getFigure(int i, int j, int number){
		int returnValue = gameMap[i][j];
		for (int k = 0; k < number; k++){
			returnValue /= 10;
		}
		return returnValue%10;
	}
	
	public void setFigure(int i, int j, int number, int newValue){
		int oldValue = getFigure(i,j,number);
		for (int k = 0; k < number; k++){
			oldValue *= 10;
			newValue *= 10;
		}
		gameMap[i][j] = gameMap[i][j] - oldValue + newValue;
	}
	
	public void compare(GameMap other){
		hasHadErrors = false;
		different = new boolean[20][30];
		for (int i = 0; i < 20; i++){
			for (int j = 0; j < 30; j++){
				if (other.gameMap[i][j] != gameMap[i][j]){
					different[i][j] = true;
					hasHadErrors = true;
					totalFaults++;
				} else {
					different[i][j] = false;
				}
			}
		}
	}
	
	public void takeAction() throws InputFileException {
		if (isInitial) {
			computeNext();
		} else {
			try {
				readMatrix();
			} catch (Exception e) {
				throw new InputFileException();
			}
		}
	}
	
	private Triplet getIntenededDestination(Integer i, Integer j) {
		int newi, newj, newdir;
		if (getFigure(i,j,1) != 0){
			// If there is an arrow here, follow it
			newi = i + vi[getFigure(i,j,1)];
			newj = j + vj[getFigure(i,j,1)];
			newdir = getFigure(i,j,1);
		} else {
			// Otherwise, just go to where you were going!
			newi = i + vi[getFigure(i,j,2)];
			newj = j + vj[getFigure(i,j,2)];
			newdir = getFigure(i,j,2);
		}
		return new Triplet(newi, newj, newdir);
	}
	
	public void computeNext() {
		int[][] nextMap = new int[20][30];
		for (int i = 0; i < 20; i++){
			for (int j = 0; j < 30; j++){
				nextMap[i][j] = 0;
				// The terrain always stays the same
				nextMap[i][j] = setFigureGeneral(nextMap[i][j], 0, getFigure(i,j,0));
				// The road map always stays the same
				nextMap[i][j] = setFigureGeneral(nextMap[i][j], 1, getFigure(i,j,1));
				// The crashes are always the same
				nextMap[i][j] = setFigureGeneral(nextMap[i][j], 3, getFigure(i,j,3));
			}
		}
		// Iterate over all cells in the game map and move the cars
		for (int i = 0; i < 20; i++){
			for (int j = 0; j < 30; j++){
				// If there IS a car here, then it should move
				if (getFigure(i,j,2) != 0){
					boolean swapCrash = false;
					int newi, newj, newdir;
					newi = new Integer(0);
					newj = new Integer(0);
					newdir = new Integer(0);
					Triplet t = getIntenededDestination(i, j);
					newi = t.a;
					newj = t.b;
					newdir = t.c;
					if (getFigure(newi,newj,2) != 0){
						System.out.println("There is a car at my destination: " + newi + "," + newj + " (" + i + "," + j + ")");
						// If the place where you want to move contains a car now
						int dest_newi, dest_newj, dest_newdir;
						Triplet newt = getIntenededDestination(newi, newj);
						dest_newi = newt.a;
						dest_newj = newt.b;
						dest_newdir = newt.c;
						System.out.println("Which wants to move to: " + dest_newi + "," + dest_newj + " (" + newi + "," + newj + ")");
						System.out.println(i + " " + j + " - " + dest_newi + " " + dest_newj);
						// If you're actually swapping places, then it's a swap crash
						if (dest_newi == i && dest_newj == j){
							swapCrash = true;
						}
					}
					if (swapCrash == false && getFigureGeneral(nextMap[newi][newj], 0) == 0 && getFigureGeneral(nextMap[newi][newj], 2) == 0 && getFigureGeneral(nextMap[newi][newj],3) == 0){
						// If the terrain up ahead is a road, and there is no car there yet, and no accident, move there
						nextMap[newi][newj] = setFigureGeneral(nextMap[newi][newj],2,newdir);
					} else {
						// Move there, but crash like a crying bitch
						nextMap[newi][newj] = setFigureGeneral(nextMap[newi][newj],3,1);
						nextMap[newi][newj] = setFigureGeneral(nextMap[newi][newj],2,0);
					}
				}
			}
		}
		gameMap = nextMap;
		allStates.add(gameMap);
	}
	
	public void readMatrix() throws InputFileException, IOException {
		for (int i = 0; i < 20; i++) {
			for (int j = 0; j < 30; j++) {
				//Get the next token
				strtok.nextToken();
				if (strtok.ttype == StreamTokenizer.TT_NUMBER){
					gameMap[i][j] = (int)strtok.nval;
				} else {
					throw new InputFileException();
				}
			}
		}
	}
	
	public GameMap(String inputFile, boolean isInitial) throws InputFileException {
		// Initializers and allocators
		this.isInitial = isInitial;
		totalFaults = 0;
		gameMap = new int[20][30];
		// Reads the first matrix from the file
		try {
			// Opens the input file and reads the first 20 x 30 squares
			strtok = new StreamTokenizer(new BufferedReader(new FileReader(inputFile)));
			strtok.parseNumbers();
			readMatrix();
			allStates = new Vector<int[][]>();
			allStates.add(gameMap);
		} catch (IOException e) {
			throw new InputFileException();
		}
	}
	
}
