import java.awt.*;


public class GameCanvas extends Canvas {
	
	private static final long serialVersionUID = 1L;

	MainFrame owner;
	
	public GameMap gameMap;
	
	public GameCanvas(MainFrame owner){
		super();
		this.owner = owner;
		gameMap = null;
	}
	
	public void setGameMap(GameMap gameMap){
		this.gameMap = gameMap;
	}
	
	public void resetGameMap(){
		this.gameMap = null;
	}
	
	public void paint(Graphics g) {
		// Clear the area
		g.setColor(new Color((float)1.0, (float)1.0, (float)1.0, (float)1.0));
		g.clearRect(0, 0, 600, 400);
		// This is just debugging code
		if (gameMap == null){
			g.setColor(Color.black);
			String s = "Load map (optional: and solution) and click \"Start\"!";
			g.drawString(s, 130, 200);
		} else {
			String targetName = "none";
			// Paint an actual map
			for (int i = 0; i < 20; i++){
				for (int j = 0; j < 30; j++){
					// Paint the background terrain
					switch (gameMap.getFigure(i, j, GameMap.TERRAIN)){
					case 0:
						targetName = "road";
						break;
					case 1:
						g.drawImage(MainFrame.sprite.get("grass"),j*20,i*20, null);
						targetName = "coffee";
						break;
					case 2:
						targetName = "grass";
						break;
					case 3:
						targetName = "water";
						break;
					}
					if (targetName != "none"){
						g.drawImage(MainFrame.sprite.get(targetName),j*20,i*20, null);
					}
					// Paint the directional arrows
					switch (gameMap.getFigure(i, j, GameMap.ROADMAP)){
					case 0:
						targetName = "none";
						break;
					case 1:
						targetName = "allowedNorth";
						break;
					case 2:
						targetName = "allowedEast";
						break;
					case 3:
						targetName = "allowedSouth";
						break;
					case 4:
						targetName = "allowedWest";
						break;
					}
					if (targetName != "none"){
						g.drawImage(MainFrame.sprite.get(targetName),j*20,i*20, null);
					}
					// Paint the car 
					switch (gameMap.getFigure(i, j, GameMap.CAR)){
					case 0:
						targetName = "none";
						break;
					case 1:
						targetName = "carNorth";
						break;
					case 2:
						targetName = "carEast";
						break;
					case 3:
						targetName = "carSouth";
						break;
					case 4:
						targetName = "carWest";
						break;
					}
					if (targetName != "none"){
						g.drawImage(MainFrame.sprite.get(targetName),j*20,i*20, null);
					}
					// Paint any accidents
					switch (gameMap.getFigure(i, j, GameMap.ACCIDENTS)){
					case 0:
						targetName = "none";
						break;
					case 1:
						targetName = "crash";
						break;
					}
					if (targetName != "none"){
						g.drawImage(MainFrame.sprite.get(targetName),j*20,i*20, null);
					}
					// Pain any mismatches
					if (MainFrame.hisMap != null && MainFrame.myMap.different[i][j] == true){
						g.setColor(new Color((float)1.0, (float)0.0, (float)0.0, (float)0.5));
						g.drawRect(j*20, i*20, 20, 20);
						g.fillRect(j*20, i*20, 20, 20);
					}
				}
			}
		}
	}

}
