package cachesim;
import cachesim.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import java.io.*;
import javax.swing.*;



public class JavaCacheSimulator extends JFrame {

  
  	
  // a constant that will be used throughout this program.
	private final static Font boldFont = new Font("SansSerif", Font.BOLD, 14);
		
	Choice cacheType, cacheSizeUnified, cacheSizeInstruction, cacheSizeData, 
	 blockSizeUnified, blockSizeInstruction, blockSizeData, mappingType, replaceMode;
	 
	CacheHandler myCacheHandler = new CacheHandler ();
	
	OutputData out;

	JButton browseButton, submitButton;
	String filename;
	JTextField fileTextField, tRefTextField, iRefTextField, dRefTextField, readTextField, 
				writeTextField, iMissTextField, iProcTextField, dMissTextField, dProcTextField,
				readMissTextField, writeMissTextField, readProcTextField, writeProcTextField; 
	
	JPanel cachePanel;
	Container container;
	JavaCacheSimulator () {
	}
  	JavaCacheSimulator (String title) {
  
    	super (title);
    	
    	setBackground (Color.lightGray);
    	this.initializeComponent();
    	this.placeComponent();
		this.setupListeners(cachePanel);
		container 	= getContentPane();
		container.add(cachePanel);
		
		setSize(800,600);
	
		setVisible(true);
		
		myCacheHandler = new CacheHandler ();
		
		myCacheHandler.setCacheType(0);
	
		addWindowListener (
      		new WindowAdapter () 
      		{
      			public void windowClosing (WindowEvent e) 
      			{
      				System.exit(0);
      			}
      			public void windowDeiconified (WindowEvent e) 
      			{
      				
      			}
      			public void windowActivated (WindowEvent e) 
      			{	 
      				
      			}
      		}
      	);
	}
/*----------------------------------------------------------------------------*/	


	public static void main(String args[])
	{
		
		JavaCacheSimulator application = new JavaCacheSimulator("Java Cache Simulator");
		SplashWindow sw = new SplashWindow("cache.jpg",application,4000);
		application.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

   	
	
	private void initializeComponent() {
		
		cacheType = new Choice();
		cacheType.addItem("Unified");
		cacheType.addItem("Instruction/Data");
	
		cacheSizeUnified = new Choice();
		cacheSizeUnified.addItem("      8 kB");
		cacheSizeUnified.addItem("   16 kB");
		cacheSizeUnified.addItem("   32 kB");
		cacheSizeUnified.addItem("   64 kB");
		cacheSizeUnified.addItem("128 kB");
		cacheSizeUnified.addItem("256 kB");
		
		cacheSizeInstruction = new Choice();
		cacheSizeInstruction.addItem("      8 kB");
		cacheSizeInstruction.addItem("   16 kB");
		cacheSizeInstruction.addItem("   32 kB");
		cacheSizeInstruction.addItem("   64 kB");
		cacheSizeInstruction.addItem("128 kB");
		cacheSizeInstruction.addItem("256 kB");
		
		cacheSizeData = new Choice();
		cacheSizeData.addItem("      8 kB");
		cacheSizeData.addItem("   16 kB");
		cacheSizeData.addItem("   32 kB");
		cacheSizeData.addItem("   64 kB");
		cacheSizeData.addItem("128 kB");
		cacheSizeData.addItem("256 kB");
		
		blockSizeUnified = new Choice();
		blockSizeUnified.addItem("1");
		blockSizeUnified.addItem("2");
		blockSizeUnified.addItem("4");
		blockSizeUnified.addItem("8");
		blockSizeUnified.addItem("16");
		blockSizeUnified.addItem("32");
		
		blockSizeInstruction = new Choice();
		blockSizeInstruction.addItem("1");
		blockSizeInstruction.addItem("2");
		blockSizeInstruction.addItem("4");
		blockSizeInstruction.addItem("8");
		blockSizeInstruction.addItem("16");
		blockSizeInstruction.addItem("32");
		
		blockSizeData = new Choice();
		blockSizeData.addItem("1");
		blockSizeData.addItem("2");
		blockSizeData.addItem("4");
		blockSizeData.addItem("8");
		blockSizeData.addItem("16");
		blockSizeData.addItem("32");
		
		mappingType = new Choice();
		mappingType.addItem("Set-Associative");
		mappingType.addItem("Fully-Associative");
		mappingType.addItem("Direct-Mapped");
		
		replaceMode = new Choice();
		replaceMode.addItem("LRU");
		replaceMode.addItem("FIFO");
		replaceMode.addItem("RANDOM");
		
	}

	private void placeComponent() {
		// temp pointers that will be used throughout this method.
		Label tempLabel;
		
		cachePanel = new JPanel();
		GridBagLayout cacheLayout = new GridBagLayout();
		GridBagConstraints cacheConstraints = new GridBagConstraints();
		cachePanel.setLayout(cacheLayout);
		
		// grid bag first row -- cache type
		cacheConstraints.anchor = GridBagConstraints.WEST;
		tempLabel = new Label("Cache Type: ");
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheLayout.setConstraints(cacheType, cacheConstraints);
		cachePanel.add(cacheType);
			
		// grid bag second row --  cacheSizeUnified...
		cacheConstraints.gridwidth = 1;
		cacheConstraints.gridx = 0;
		cacheConstraints.gridy = 1;
		// cacheSizeUnified
		tempLabel = new Label("Cache Size Unified:");
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 1;
		cacheLayout.setConstraints(cacheSizeUnified, cacheConstraints);
		cachePanel.add(cacheSizeUnified);
		// cacheSizeInstruction
		tempLabel = new Label("Cache Size Instruction:");
		cacheConstraints.gridx = 2;
		cacheConstraints.insets = new Insets(8, 15, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 3;
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(cacheSizeInstruction, cacheConstraints);
		cachePanel.add(cacheSizeInstruction);
		cacheSizeInstruction.setEnabled(false);
		// cacheSizeData
		tempLabel = new Label("Cache Size Data:");
		cacheConstraints.gridx = 4;
		cacheConstraints.insets = new Insets(10, 15, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 5;
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(cacheSizeData, cacheConstraints);
		cachePanel.add(cacheSizeData);
		cacheSizeData.setEnabled(false);
		// grid bag third row --  blockSizeUnified...
		cacheConstraints.gridwidth = 1;
		cacheConstraints.gridx = 0;
		cacheConstraints.gridy = 2;
		// blockSizeUnified
		tempLabel = new Label("Block Size Unified:");
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 1;
		cacheLayout.setConstraints(blockSizeUnified, cacheConstraints);
		cachePanel.add(blockSizeUnified);
		// blockSizeInstruction
		tempLabel = new Label("Block Size Instruction:");
		cacheConstraints.gridx = 2;
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 3;
		cacheLayout.setConstraints(blockSizeInstruction, cacheConstraints);
		cachePanel.add(blockSizeInstruction);
		blockSizeInstruction.setEnabled(false);
		// blockSizeData
		tempLabel = new Label("Block Size Data:");
		cacheConstraints.gridx = 4;
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 5;
		cacheLayout.setConstraints(blockSizeData, cacheConstraints);
		cachePanel.add(blockSizeData);
		blockSizeData.setEnabled(false);
		
		// grid bag fourth row 
		cacheConstraints.gridy = 3;
		cacheConstraints.gridx = 0;
		//mappingType
		tempLabel = new Label("Mapping Type:");
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 1;
		cacheLayout.setConstraints(mappingType, cacheConstraints);
		cachePanel.add(mappingType);
		//replaceMode
		tempLabel = new Label("Replace Mode:");
		cacheConstraints.gridx = 2;
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		cacheConstraints.gridx = 3;
		cacheLayout.setConstraints(replaceMode, cacheConstraints);
		cachePanel.add(replaceMode);
		replaceMode.setEnabled(false);
	
		// grid bag fifth row 
		cacheConstraints.gridy = 4;
		cacheConstraints.gridx = 0;
		browseButton = new JButton("Browse");
		cacheConstraints.insets = new Insets(10, 0, 0, 0);
		cacheLayout.setConstraints(browseButton, cacheConstraints);
		cachePanel.add(browseButton);
		fileTextField = new JTextField("                                              ");
		cacheConstraints.gridx = 1;
		cacheLayout.setConstraints(fileTextField, cacheConstraints);
		cachePanel.add(fileTextField);
		
		// grid bag fifth row 
		cacheConstraints.gridy = 5;
		cacheConstraints.gridx = 1;
		submitButton = new JButton ("Simulate");
		cacheConstraints.insets = new Insets(10, 0, 0, 0);
		cacheLayout.setConstraints(submitButton, cacheConstraints);
		cachePanel.add(submitButton);
		
		// grid bag sixth row
		JTextField lulu = setOutputTextField(2,7,"SIMULATION RESULTS", cacheConstraints,cacheLayout,0);
		
		tRefTextField = setOutputTextField(0,8,"Total References", cacheConstraints,cacheLayout,1);
		
		iRefTextField = setOutputTextField(0,9,"Instruction References", cacheConstraints,cacheLayout,1);
		
		iMissTextField = setOutputTextField(2,9,"Instruction Misses", cacheConstraints,cacheLayout,1);
		
		iProcTextField = setOutputTextField(4,9,"Procentual Misses", cacheConstraints,cacheLayout,1);
		
		dRefTextField = setOutputTextField(0,10,"Data References", cacheConstraints,cacheLayout,1);
		
		dMissTextField = setOutputTextField(2,10,"Data Misses", cacheConstraints,cacheLayout,1);
		
		dProcTextField = setOutputTextField(4,10,"Procentual Misses", cacheConstraints,cacheLayout,1);
		
		readTextField = setOutputTextField(0,11,"Read Data", cacheConstraints,cacheLayout,1);
		
		readMissTextField = setOutputTextField(2,11,"Read Misses", cacheConstraints,cacheLayout,1);
		
		readProcTextField = setOutputTextField(4,11,"Procentual Misses", cacheConstraints,cacheLayout,1);
		
		writeTextField = setOutputTextField(0,12,"Write Data", cacheConstraints,cacheLayout,1);
		
		writeMissTextField = setOutputTextField(2,12,"Write Misses", cacheConstraints,cacheLayout,1);
		
		writeProcTextField = setOutputTextField(4,12,"Procentual Misses", cacheConstraints,cacheLayout,1);
		
		
		// grid bag row
		
	}
	
	private JTextField setOutputTextField (int x,int y, String name, GridBagConstraints cacheConstraints, GridBagLayout cacheLayout, int sw ) {
		JTextField tf;
		cacheConstraints.gridy = y;
		cacheConstraints.gridx = x;
		Label tempLabel = new Label(name);
		cacheConstraints.insets = new Insets(10, 0, 0, 0);		// padding
		cacheLayout.setConstraints(tempLabel, cacheConstraints);
		cachePanel.add(tempLabel);
		if(sw == 1) {
			tf = new JTextField("              ");
			cacheConstraints.gridx = x+1;
			cacheLayout.setConstraints(tf, cacheConstraints);
			cachePanel.add(tf);
			tf.setEditable(false);
		}
		
		else
			tf = new JTextField ();
		
		return tf;
		
	}
	
	private void printOutput(OutputData out) {
		
					
		tRefTextField.setText(""+out.getRefNum());
		iRefTextField.setText(""+out.getInstrNum());
		dRefTextField.setText(""+out.getDataNum());
		readTextField.setText(""+out.getReadNum());
		writeTextField.setText(""+out.getWriteNum());
		iMissTextField.setText(""+out.getInstrMissNum());
		String str = ""+(float)out.getInstrMissNum()/out.getInstrNum()*100;
		iProcTextField.setText(str.substring(0,4)+" %");
		str = ""+(float)out.getDataMissNum()/out.getDataNum()*100;
		dProcTextField.setText(str.substring(0,4)+" %");
		dMissTextField.setText(""+out.getDataMissNum());
		readMissTextField.setText(""+out.getReadMissNum());
		str = ""+(float)out.getReadMissNum()/out.getReadNum()*100;
		readProcTextField.setText(str.substring(0,4)+" %");
		writeMissTextField.setText(""+out.getWriteMissNum());
		str = ""+(float)out.getWriteMissNum()/out.getWriteNum()*100;
		writeProcTextField.setText(str.substring(0,4)+" %");
	}
	private void setupListeners(JPanel cachePanel) {
		
		final JPanel cachepanel = cachePanel;
		
		/*Choice cacheType, cacheSizeUnified, cacheSizeInstruction, cacheSizeData, 
	 blockSizeUnified, blockSizeInstruction, blockSizeData, mappingType, replaceMode;*/
		
		cacheType.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if(cacheType.getSelectedItem().equals("Unified")) {
					cacheSizeInstruction.setEnabled(false);
					cacheSizeData.setEnabled(false);
					blockSizeInstruction.setEnabled(false);
					blockSizeData.setEnabled(false);
					cacheSizeUnified.setEnabled(true);
					blockSizeUnified.setEnabled(true);
				}
				if(cacheType.getSelectedItem().equals("Instruction/Data")) {
					cacheSizeUnified.setEnabled(false);
					blockSizeUnified.setEnabled(false);
					cacheSizeInstruction.setEnabled(true);
					cacheSizeData.setEnabled(true);
					blockSizeInstruction.setEnabled(true);
					blockSizeData.setEnabled(true);
				}
				myCacheHandler.setCacheType(cacheType.getSelectedIndex());
			}
			
			
		});
		
		cacheSizeUnified.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setCacheDimData (cacheSizeUnified.getSelectedIndex());
			}
		});
		
		cacheSizeData.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setCacheDimData (cacheSizeData.getSelectedIndex());		
			}
		});
		
		cacheSizeInstruction.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setCacheDimInstruction (cacheSizeInstruction.getSelectedIndex());
			}
		});
		
		blockSizeUnified.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setBlockDimData (blockSizeUnified.getSelectedIndex());
			}
		});
		
		blockSizeData.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setBlockDimData (blockSizeData.getSelectedIndex());		
			}
		});
		
		blockSizeInstruction.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setBlockDimInstruction (blockSizeInstruction.getSelectedIndex());
			}
		});
		
		mappingType.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setCacheMapping(mappingType.getSelectedIndex());
				if (mappingType.getSelectedIndex() == 2 || mappingType.getSelectedIndex() == 0)
					replaceMode.setEnabled(false);
				else
					replaceMode.setEnabled(true);
			}
		});
		
		replaceMode.addItemListener(new ItemListener () {
			public void itemStateChanged(ItemEvent e) {
				myCacheHandler.setReplaceMode (replaceMode.getSelectedIndex());
				
			}
		});
		
		browseButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser fd = new JFileChooser();
        		int returnVal=fd.showOpenDialog(cachepanel);
        		if(returnVal==JFileChooser.APPROVE_OPTION )
        		{
        			
        			if (fd.getSelectedFile() == null)
                    { return; }
                	File file=fd.getSelectedFile();
                	String path=(String)file.getPath();
            		filename = path;
            		fileTextField.setText(filename);
            		myCacheHandler.setFile(file);
       			}
       		}
       	});
       	
       	submitButton.addActionListener (new ActionListener() {
			public void actionPerformed (ActionEvent e) {
				myCacheHandler.simulate ();
				out = myCacheHandler.getOutData ();
				if (out == null)
					System.out.println ("E NULL!");
				else
					printOutput(out);
				
       		}
       	});
	}
		
}

class SplashWindow extends JWindow
{
    public SplashWindow(String filename, JFrame f, int waitTime)
    {
       //super(f);
        JLabel l = new JLabel(new ImageIcon(filename));
        getContentPane().add(l, BorderLayout.CENTER);
        pack();
        Dimension screenSize =
          Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        setLocation(screenSize.width/2 - (labelSize.width/2),
                    screenSize.height/2 - (labelSize.height/2));
        addMouseListener(new MouseAdapter()
            {
                public void mousePressed(MouseEvent e)
                {
                    setVisible(false);
                    dispose();
                }
            });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable()
            {
                public void run()
                {
                    setVisible(false);
                    dispose();
                }
            };
        Runnable waitRunner = new Runnable()
            {
                public void run()
                {
                    try
                        {
                            Thread.sleep(pause);
                            SwingUtilities.invokeAndWait(closerRunner);
                        }
                    catch(Exception e)
                        {
                            e.printStackTrace();
                            // can catch InvocationTargetException
                            // can catch InterruptedException
                        }
                }
            };
        setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }
}


