package cachesim;
import java.io.*;
import java.util.*;
import java.lang.*;

class ReferenceData {
	private int label;
	private int address;
	
	public ReferenceData () {
	}
	
	public ReferenceData (int l, int a) {
		label = l;
		address = a;
	}
	
	public void setReferenceData (int l, int a) {
		label = l;
		address = a;
	}
	
	public void setLabel (int l) {
		label = l;
	}
	
	public void setAddress (int a) {
		address = a;
	}
	
	public int getLabel () { 
		return label;
	}
	
	public int getAddress ()	{
		return address;
	}
		
}

class MemoryHandler {
	RandomAccessFile file;
	ReferenceData data;
	
	public MemoryHandler (File cachefile) {
		try {
			file = new RandomAccessFile (cachefile, "rw");
		} catch (Exception e) {
			System.out.println (e);
		}
	}

	public MemoryHandler () {
	}
	
	public void setSeek () {
		try {
			file.seek(0);
		} catch (Exception e) {
			System.out.println (e);
		}
	}
	
	public ReferenceData getNextElem () {
		int sl, saddr;
		String sa;
		StringTokenizer st;
		
		try {
			sa = file.readLine ();
			if (sa == null)
				return null;
			st = new StringTokenizer (sa);
			sl = Integer.parseInt (st.nextToken ());
			saddr = Integer.parseInt (st.nextToken (), 16);
			System.out.println (sl + " ");
			System.out.println (saddr);
			
			data = new ReferenceData (sl, saddr);		
		} catch (EOFException e) {
			return null;
		} catch (IOException ex) {
			System.out.println (ex + " in getNext");
		}
			
		return data;
	}
}